function setInitialValues(obj)
% SETINITIALVLUES Set initial values for auxiliary states and controls

	%% Get names of states from obj
    [stateNames, auxNames, ctrlNames, ...
    paramNames, inputNames] = getFieldNames(obj);

    for n=1:length(paramNames)
        p.(paramNames{n}) = obj.p.(paramNames{n}).val;
    end

    for n=1:length(stateNames)
        % if a trajectory is defined (val is not scalar), set the initial
        % value back to the first value in the trajectory
        if isscalar(obj.x.(stateNames{n}).val) 
            x.(stateNames{n}) = obj.x.(stateNames{n}).val;
        else
            x.(stateNames{n}) = obj.x.(stateNames{n}).val(1,2); 
        end
    end

    for n=1:length(inputNames)
        % set the initial value to the first value in the trajectory
        d.(inputNames{n}) = obj.d.(inputNames{n}).val(1,2); 
    end
    
    for n=1:length(ctrlNames)
        if isempty(obj.u.(ctrlNames{n}).val) % no value given, need to calculate
            try
                u.(ctrlNames{n}) = eval(obj.u.(ctrlNames{n}).def);
            catch err
                msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement u.%s (n=%d): \n\t''%s''',...
                    err.message, ctrlNames{n}, n, obj.u.(ctrlNames{n}).def);
                id = 'MATLAB:StateSpaceModel:eval';
                error(id,msg);
            end
        elseif ~isscalar(obj.u.(ctrlNames{n}).val) 
            % trajectory of control defined, take only first value in trajectory
            u.(ctrlNames{n}) = obj.u.(ctrlNames{n}).val(1,2); 
        end
    end
    
    for n=1:length(auxNames)
        try
            obj.a.(auxNames{n}).val = eval(obj.a.(auxNames{n}).def);
        catch err
            msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement a.%s (n=%d): \n\t''%s''',...
                err.message, auxNames{n}, n, obj.a.(auxNames{n}).def);
            id = 'MATLAB:StateSpaceModel:eval';
            error(id,msg);
        end
        a.(auxNames{n}) = obj.a.(auxNames{n}).val;
    end
end






function dxdt = getOde(t, x, ssm)
% GETODE Get the ODEs of a StateSpaceModel in a format for MATLAB's ODE solvers

    [stateNames, auxNames, ctrlNames, paramNames, inputNames] = getFieldNames(obj);
        
    % get inputs d
    for k=1:length(inputNames)
        if t < obj.d.(inputNames{k}).val(1,1)
            d.(inputNames{k}) = obj.d.(inputNames{k}).val(1,2);
        elseif t > obj.d.(inputNames{k}).val(end,1)
            d.(inputNames{k}) = obj.d.(inputNames{k}).val(end,2);
        else
            d.(inputNames{k}) = interp1(obj.d.(inputNames{k}).val(:,1),...
                obj.d.(inputNames{k}).val(:,2),t); 
        end                
    end
        
    % get controls u 
    for k=1:length(ctrlNames)
        if strcmp(obj.u.(ctrlNames{k}).def, ['u.' ctrlNames{k}]) 
            % the def for the control is the control name, control acts as input
             if t < obj.u.(ctrlNames{k}).val(1,1)
                u.(ctrlNames{k}) = obj.u.(ctrlNames{k}).val(1,2);
            elseif t > obj.u.(ctrlNames{k}).val(end,1)
                u.(ctrlNames{k}) = obj.u.(ctrlNames{k}).val(end,2);
            else
                u.(ctrlNames{k}) = interp1(obj.u.(ctrlNames{k}).val(:,1),...
                    obj.u.(ctrlNames{k}).val(:,2),tHalf); 
             end
        else % control is rule based, acts as an auxiliary state
            % need to calculate
            try
                u.(ctrlNames{k}) = eval(obj.u.(ctrlNames{k}).def);
            catch err
                msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement u.%s (k=%d): \n\t''%s''',...
                    err.message, ctrlNames{k}, k, obj.u.(ctrlNames{k}).def);
                id = 'MATLAB:StateSpaceModel:eval';
                error(id,msg);
            end
        end
    end
    
    
        % get uHalf = u(xHalf, a0)
    x = xHalf;
    d = dHalf;
    a = a0;
    u = u0;
    if nextCtrl
        for k=1:length(ctrlNames)
            if isempty(u.(ctrlNames{k})) % need to calculate
                
            end
        end
    else
        u = u0;
    end
    
end


%     
%     % get aHalf = a(xHalf, uHalf)
%     u = uHalf;
%     for n=1:length(auxNames)
%         try
%             aHalf.(auxNames{n}) = eval(obj.a.(auxNames{n}).def);
%         catch err
%             msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement a.%s (n=%d): \n\t''%s''',...
%                 err.message, auxNames{n}, n, obj.a.(auxNames{n}).def);
%             id = 'MATLAB:StateSpaceModel:eval';
%             error(id,msg);
%         end
%     end
%         
% 
%     % Calculate k2 = stepSize*f(tHalf,x0+k1/2)
%     k2  = getK(obj, stepSize, xHalf, aHalf, uHalf, dHalf, p);
% 
%     % calculate xHalf = x+k2/2
%     for k=1:length(stateNames)
%         xHalf.(stateNames{k}) = x0.(stateNames{k})+1/2*k2.(stateNames{k});            
%     end
%     
%     % get uHalf = u(xHalf)
%     x = xHalf;
%     d = dHalf;
%     if nextCtrl
%         for k=1:length(ctrlNames)
%             if isempty(uHalf.(ctrlNames{k})) % need to calculate
%                 try
%                     uHalf.(ctrlNames{k}) = eval(obj.u.(ctrlNames{k}).def);
%                 catch err
%                     msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement u.%s (k=%d): \n\t''%s''',...
%                         err.message, ctrlNames{k}, k, obj.u.(ctrlNames{k}).def);
%                     id = 'MATLAB:StateSpaceModel:eval';
%                     error(id,msg);
%                 end
%             end
%         end
%     else
%         uHalf = u0;
%     end
% 
%     % get aHalf = a(xHalf, uHalf)
%     u = uHalf;
%     for n=1:length(auxNames)
%         try
%             aHalf.(auxNames{n}) = eval(obj.a.(auxNames{n}).def);
%         catch err
%             msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement a.%s (n=%d): \n\t''%s''',...
%                 err.message, auxNames{n}, n, obj.a.(auxNames{n}).def);
%             id = 'MATLAB:StateSpaceModel:eval';
%             error(id,msg);
%         end
%     end
%     
%     % Calculate k3 = stepSize*f(tHalf,x0+k2/2)
%     k3  = getK(obj, stepSize, xHalf, aHalf, uHalf, dHalf, p);
% 
%     % calculate xHalf = x+k3
%     for k=1:length(stateNames)
%         xHalf.(stateNames{k}) = x0.(stateNames{k})+k3.(stateNames{k});            
%     end
%     
%     % get uHalf = u(xHalf)
%     x = xHalf;
%     d = dHalf;
%     if nextCtrl
%         for k=1:length(ctrlNames)
%             if isempty(uHalf.(ctrlNames{k})) % need to calculate
%                 try
%                     uHalf.(ctrlNames{k}) = eval(obj.u.(ctrlNames{k}).def);
%                 catch err
%                     msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement u.%s (k=%d): \n\t''%s''',...
%                         err.message, ctrlNames{k}, k, obj.u.(ctrlNames{k}).def);
%                     id = 'MATLAB:StateSpaceModel:eval';
%                     error(id,msg);
%                 end
%             end
%         end
%     else
%         uHalf = u0;
%     end
%     
%     % get aHalf = a(xHalf, uHalf)
%     u = uHalf;
%     for n=1:length(auxNames)
%         try
%             aHalf.(auxNames{n}) = eval(obj.a.(auxNames{n}).def);
%         catch err
%             msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement a.%s (n=%d): \n\t''%s''',...
%                 err.message, auxNames{n}, n, obj.a.(auxNames{n}).def);
%             id = 'MATLAB:StateSpaceModel:eval';
%             error(id,msg);
%         end
%     end
% 
%     % Calculate k4 = stepSize*f(t1,x0+k3)
%     k4  = getK(obj, stepSize, xHalf, aHalf, uHalf, d1, p);
% 
%     % calculate x1 = x0+1/6(k1+2*k2+2*k3+k4)
%     for k=1:length(stateNames)
%         x1.(stateNames{k}) = x0.(stateNames{k})+...
%             1/6*(k1.(stateNames{k})+2*k2.(stateNames{k})+2*k3.(stateNames{k})...
%             +k4.(stateNames{k}));            
%     end
%     
%     % get u1 = u(x1)
%     x = x1;
%     d = d1;
%     if nextCtrl
%         u = uHalf;
%         for k=1:length(ctrlNames)
%             if isempty(u1.(ctrlNames{k})) % need to calculate
%                 try
%                     u1.(ctrlNames{k}) = eval(obj.u.(ctrlNames{k}).def); 
%                 catch err
%                     msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement u.%s (k=%d): \n\t''%s''',...
%                         err.message, ctrlNames{k}, k, obj.u.(ctrlNames{k}).def);
%                     id = 'MATLAB:StateSpaceModel:eval';
%                     error(id,msg);
%                 end
%             end
%         end
%     else
%         u1 = u0;
%     end
%     
%     % get a1 = a(x1, u1)
%     u = u1;
%     for n=1:length(auxNames)
%         try
%             a1.(auxNames{n}) = eval(obj.a.(auxNames{n}).def);
%         catch err
%             msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement a.%s (n=%d): \n\t''%s''',...
%                 err.message, auxNames{n}, n, obj.a.(auxNames{n}).def);
%             id = 'MATLAB:StateSpaceModel:eval';
%             error(id,msg);
%         end
%     end
% end
% 
% function k = getK(obj, stepSize, x, a, u, d, p)
%     % k = stepSize*f(t,x)
%     
%     [stateNames, ~, ~, ~, ~] = getFieldNames(obj);
%     
%     for n=1:length(stateNames)
%         try
%             k.(stateNames{n}) = stepSize*eval(obj.x.(stateNames{n}).def);
%         catch err
%             msg = sprintf('%s \n\nFailed to evaluate the definition of DynamicElement x.%s (k=%d): \n\t''%s''',...
%                 err.message, stateNames{n}, n, obj.x.(stateNames{n}).def);
%             id = 'MATLAB:StateSpaceModel:eval';
%             error(id,msg);
%         end
%         if ~isreal(k.(stateNames{n}))
%             warning('x.%s is complex',stateNames{n});
%         elseif isnan(k.(stateNames{n}))
%             warning('x.%s is NaN',stateNames{n});
%         end
%     end
% end
% 
% 
% end